﻿//****************************
//Register Namespace
//****************************

//Registers the ServiceCommunication namespace
Type.registerNamespace('ServiceCommunication');


//*****************************
//Create and Register Class
//*****************************

//ComplexWCFService constructor
ServiceCommunication.ComplexWCFService=function() {
    //initializes the Sys.Net.WebServiceProxy class
    ServiceCommunication.ComplexWCFService.initializeBase(this);
    this._timeout = 0;
    this._userContext = null;
    this._succeeded = null;
    this._failed = null;
    this._path = "/ComplexWCFService_InternalService.axd";
}

//SimpelService prototype
ServiceCommunication.ComplexWCFService.prototype={
    //Save method which calls the Save2 Method in the Http Handler 
    save2:function(variousEntities,stringValue,various2,intValue,succeededCallback, failedCallback, userContext) {
        /// <param name="variousEntities" type="ServiceData.Complex.VariousEntities">ServiceData.Complex.VariousEntities</param>
        /// <param name="stringValue" type="String">System.String</param>
        /// <param name="various2" type="ServiceData.Complex.VariousEntities">ServiceData.Complex.VariousEntities</param>
        /// <param name="intValue" type="Number">System.Int32</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        var o = this._invoke(this.get_path(), 'Save2',false,{variousEntities:variousEntities,stringValue:stringValue,various2:various2,intValue:intValue},succeededCallback,failedCallback,userContext);
        return o;
    },
    //Save method which calls the Save method in the Http Handler
    save:function(variousEntities,succeededCallback, failedCallback, userContext) {
        /// <param name="entity" type="ServiceData.Complex.VariousEntities">ServiceData.Complex.VariousEntities</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'Save',false,{variousEntities:variousEntities},succeededCallback,failedCallback,userContext); 
    },
    //Save business method which calls the SaveBusiness method in the Http Handler
    saveBusiness:function(entity,succeededCallback, failedCallback, userContext) {
        /// <param name="entity" type="ServiceData.Complex.BusinessEntity">ServiceData.Complex.BusinessEntity</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'SaveBusiness',false,{business:entity},succeededCallback,failedCallback,userContext); 
    },
    //Save customer method which calls the SaveCustomer method in the Http Handler
    saveCustomer:function(entity,succeededCallback, failedCallback, userContext) {
        /// <param name="entity" type="ServiceData.Complex.CustomerEntity">ServiceData.Complex.CustomerEntity</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'SaveCustomer',false,{customer:entity},succeededCallback,failedCallback,userContext); 
    },
    //Save vendor method which calls the SaveVendor method in the Http Handler
    saveVendor:function(entity,succeededCallback, failedCallback, userContext) {
        /// <param name="entity" type="ServiceData.Complex.VendorEntity">ServiceData.Complex.VendorEntity</param>
        /// <param name="succeededCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="failedCallback" type="Function" optional="true" mayBeNull="true"></param>
        /// <param name="userContext" optional="true" mayBeNull="true"></param>
        return this._invoke(this.get_path(), 'SaveVendor',false,{vendor:entity},succeededCallback,failedCallback,userContext); 
    }

}

//Register the class with it's base class Sys.Net.WebServcieProxy
ServiceCommunication.ComplexWCFService.registerClass('ServiceCommunication.ComplexWCFService',Sys.Net.WebServiceProxy);


//********************
//Register Known Types
//********************

//Set gtc to generateTypeConstructor method
var gtc = Sys.Net.WebServiceProxy._generateTypedConstructor;

//Register data namespace
Type.registerNamespace('ServiceData.Complex');

if (typeof(ServiceData.Complex.VariousEntities) === 'undefined') {
ServiceData.Complex.VariousEntities=gtc("VariousEntities:#ServiceData.Complex");
ServiceData.Complex.VariousEntities.registerClass('ServiceData.Complex.VariousEntities');
}
if (typeof(ServiceData.Complex.BusinessEntity) === 'undefined') {
ServiceData.Complex.BusinessEntity=gtc("BusinessEntity:#ServiceData.Complex");
ServiceData.Complex.BusinessEntity.registerClass('ServiceData.Complex.BusinessEntity');
}
if (typeof(ServiceData.Complex.CustomerEntity) === 'undefined') {
ServiceData.Complex.CustomerEntity=gtc("CustomerEntity:#ServiceData.Complex");
ServiceData.Complex.CustomerEntity.registerClass('ServiceData.Complex.CustomerEntity');
}
if (typeof(ServiceData.Complex.VendorEntity) === 'undefined') {
ServiceData.Complex.VendorEntity=gtc("VendorEntity:#ServiceData.Complex");
ServiceData.Complex.VendorEntity.registerClass('ServiceData.Complex.VendorEntity');
}

/*
//Register VariousEntities
if (typeof(ServiceData.Complex.VariousEntities) === 'undefined') {
ServiceData.Complex.VariousEntities=gtc("ServiceData.Complex.VariousEntities");
ServiceData.Complex.VariousEntities.registerClass('ServiceData.Complex.VariousEntities');
}

//Register BusinessEntity
if (typeof(ServiceData.Complex.BusinessEntity) === 'undefined') {
ServiceData.Complex.BusinessEntity=gtc("ServiceData.Complex.BusinessEntity");
ServiceData.Complex.BusinessEntity.registerClass('ServiceData.Complex.BusinessEntity');
}


//Register CustomerEntity
if (typeof(ServiceData.Complex.CustomerEntity) === 'undefined') {
ServiceData.Complex.CustomerEntity=gtc("ServiceData.Complex.CustomerEntity");
ServiceData.Complex.CustomerEntity.registerClass('ServiceData.Complex.CustomerEntity');
}

//Register VendorEntity
if (typeof(ServiceData.Complex.VendorEntity) === 'undefined') {
ServiceData.Complex.VendorEntity=gtc("ServiceData.Complex.VendorEntity");
ServiceData.Complex.VendorEntity.registerClass('ServiceData.Complex.VendorEntity');
}
*/


